class Point {
public:
    int x, y;
    Point(int x=0, int y=0): x(x), y(y) {}
    bool operator == (const Point p) const {
        return x == p.x && y == p.y;
    }
    operator size_t() const {
        return (size_t)(x ^ y);
            // xor is the best operation for hashing
    }
};

void findPointsWithinRadius(Point center, int radius, 
                            unordered_set<Point> &points) {
    points.clear();
    int max = radius*radius;
    for (int x = center.x - radius; 
            x <= center.x + radius; ++x) {
        int xDist = center.x - x;
        for (int y = center.y - radius; 
                y <= center.y + radius; ++y) {
            int yDist = center.y - y;
            if (xDist*xDist + yDist*yDist <= max) 
            points.insert(Point(x,y));
        }
    }
}

void outputPointsInDisk(Point center, int radius) {
    unordered_set<Point> points;
    findPointsWithinRadius(center,radius,points);
    bool first = true;
    for (unordered_set<Point>::iterator i = points.begin();
            i != points.end(); ++i) {
        if (!first) cout << ", ";
        first = false;
        cout << *i;
    }
    cout << endl;
}

int main() {
    outputPointsInDisk(Point(),2);
    return 0;
}
